<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SupportTicketReply extends Model
{
    protected $fillable = ['ticket_id', 'user_id', 'is_admin', 'message', 'attachments'];

    protected $casts = [
        'attachments' => 'array',
        'is_admin' => 'boolean'
    ];

    public function ticket()
    {
        return $this->belongsTo(SupportTicket::class, 'ticket_id');
    }

    public function user()
    {
        return $this->belongsTo(\App\Models\User::class);
    }
}
