<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SupportSetting extends Model
{
    protected $fillable = [
        'support_email',
        'support_phone',
        'ticket_enabled',
        'chat_enabled',
        'email_enabled',
        'call_enabled',
        'business_hours',
        'auto_reply_message',
        'ticket_instructions',
        'avg_response_time_hours'
    ];

    protected $casts = [
        'business_hours' => 'array',
        'ticket_enabled' => 'boolean',
        'chat_enabled' => 'boolean',
        'email_enabled' => 'boolean',
        'call_enabled' => 'boolean'
    ];

    public static function current()
    {
        return self::first() ?? self::create([]);
    }
}
