<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SupportChatMessage extends Model
{
    protected $fillable = ['chat_id', 'user_id', 'is_admin', 'message', 'read_at'];

    protected $casts = [
        'is_admin' => 'boolean',
        'read_at' => 'datetime'
    ];

    public function chat()
    {
        return $this->belongsTo(SupportChat::class, 'chat_id');
    }

    public function user()
    {
        return $this->belongsTo(\App\Models\User::class);
    }
}
