<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SupportChat extends Model
{
    protected $fillable = ['user_id', 'status', 'assigned_to', 'last_message_at', 'last_seen_by_admin', 'closed_at'];

    protected $casts = [
        'last_message_at' => 'datetime',
        'last_seen_by_admin' => 'datetime',
        'closed_at' => 'datetime'
    ];

    public function user()
    {
        return $this->belongsTo(\App\Models\User::class);
    }

    public function assignedAdmin()
    {
        return $this->belongsTo(\App\Models\User::class, 'assigned_to');
    }

    public function messages()
    {
        return $this->hasMany(SupportChatMessage::class, 'chat_id');
    }

    public function latestMessage()
    {
        return $this->hasOne(SupportChatMessage::class, 'chat_id')->latest();
    }
}
