<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'slug',
        'content',
        'is_active',
        'is_system_page',
        'show_in_app',
        'order',
        'meta',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_system_page' => 'boolean',
        'show_in_app' => 'boolean',
        'meta' => 'array',
    ];

    /**
     * Scope to get only active pages
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope to get only pages that should show in app
     */
    public function scopeShowInApp($query)
    {
        return $query->where('show_in_app', true);
    }

    /**
     * Scope to order pages
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('order', 'asc');
    }
}
