<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GuardianLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'action',
        'target_type',
        'target_id',
        'reason',
        'snapshot',
        'is_overwritten',
        'admin_id'
    ];

    protected $casts = [
        'snapshot' => 'array',
        'is_overwritten' => 'boolean',
    ];

    public function target()
    {
        return $this->morphTo();
    }
}
