<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlogCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'description',
        'icon',
        'color',
        'order',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get blogs in this category
     */
    public function blogs()
    {
        return $this->hasMany(Blog::class);
    }

    /**
     * Get published blogs count
     */
    public function publishedBlogsCount()
    {
        return $this->blogs()->where('is_published', true)->count();
    }

    /**
     * Scope to get only active categories
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope to order categories
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('order', 'asc');
    }
}
