<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BannerTransaction extends Model
{
    protected $fillable = [
        'user_id',
        'banner_id',
        'package_id',
        'transaction_type',
        'amount',
        'impressions_purchased',
        'clicks_purchased',
        'payment_method',
        'payment_status',
        'payment_gateway_response'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'payment_gateway_response' => 'array'
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function banner()
    {
        return $this->belongsTo(Banner::class);
    }

    public function package()
    {
        return $this->belongsTo(BannerPackage::class, 'package_id');
    }
}
