<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BannerPackage extends Model
{
    protected $fillable = [
        'name',
        'description',
        'base_price_per_impression',
        'base_price_per_click',
        'max_impressions_included',
        'max_clicks_included',
        'features',
        'discount_percentage',
        'promotional_text',
        'is_active',
        'display_order'
    ];

    protected $casts = [
        'features' => 'array',
        'base_price_per_impression' => 'decimal:2',
        'base_price_per_click' => 'decimal:2',
        'discount_percentage' => 'decimal:2',
        'is_active' => 'boolean'
    ];

    // Relationships
    public function banners()
    {
        return $this->hasMany(Banner::class, 'package_id');
    }

    public function transactions()
    {
        return $this->hasMany(BannerTransaction::class, 'package_id');
    }
}
