<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BannerImpression extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'banner_id',
        'user_id',
        'session_id',
        'ip_address',
        'user_agent',
        'country',
        'state',
        'city',
        'viewed_at'
    ];

    protected $casts = [
        'viewed_at' => 'datetime'
    ];

    // Relationships
    public function banner()
    {
        return $this->belongsTo(Banner::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
