<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BannerClick extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'banner_id',
        'impression_id',
        'user_id',
        'session_id',
        'ip_address',
        'country',
        'state',
        'city',
        'clicked_at'
    ];

    protected $casts = [
        'clicked_at' => 'datetime'
    ];

    // Relationships
    public function banner()
    {
        return $this->belongsTo(Banner::class);
    }

    public function impression()
    {
        return $this->belongsTo(BannerImpression::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
