<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AlgorithmConfig extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'config_key',
        'weights',
        'advanced_settings',
        'vip_settings',
        'is_active',
        'version',
        'last_updated',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'weights' => 'array',
        'advanced_settings' => 'array',
        'vip_settings' => 'array',
        'is_active' => 'boolean',
        'last_updated' => 'datetime',
    ];

    /**
     * Get the default algorithm configuration
     */
    public static function getDefault()
    {
        return self::where('config_key', 'default')->first();
    }

    /**
     * Update algorithm weights
     */
    public function updateWeights(array $weights)
    {
        $this->weights = $weights;
        $this->last_updated = now();
        $this->version++;
        return $this->save();
    }

    /**
     * Update advanced settings
     */
    public function updateAdvancedSettings(array $settings)
    {
        $this->advanced_settings = $settings;
        $this->last_updated = now();
        $this->version++;
        return $this->save();
    }

    /**
     * Update VIP settings
     */
    public function updateVIPSettings(array $vipSettings)
    {
        $this->vip_settings = $vipSettings;
        $this->last_updated = now();
        $this->version++;
        return $this->save();
    }
}
