<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdUnit extends Model
{
    use HasFactory;

    protected $fillable = [
        'ad_network_id',
        'name',
        'placement_identifier',
        'type',
        'ad_unit_id',
        'is_active',
        'frequency',
        'grid_frequency',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'frequency' => 'integer',
        'grid_frequency' => 'integer',
    ];

    /**
     * Get the network that owns the ad unit.
     */
    public function network()
    {
        return $this->belongsTo(AdNetwork::class, 'ad_network_id');
    }
}
