<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdNetwork extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'display_name',
        'app_id',
        'is_active',
        'config',
        'priority',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'config' => 'array',
        'priority' => 'integer',
    ];

    /**
     * Get the ad units for this network.
     */
    public function adUnits()
    {
        return $this->hasMany(AdUnit::class);
    }
}
