<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AdAnalyticsRealtime extends Model
{
    protected $table = 'ad_analytics_realtime';

    protected $fillable = [
        'ad_id',
        'event_type',
        'timestamp',
        'user_id',
        'session_id',
        'source',
        'ip_address',
        'user_agent',
    ];

    protected $casts = [
        'timestamp' => 'datetime',
    ];

    /**
     * Get the ad that owns this analytics event
     */
    public function ad(): BelongsTo
    {
        return $this->belongsTo(Ad::class);
    }

    /**
     * Get the user who triggered this event (if logged in)
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Scope to filter by event type
     */
    public function scopeOfType($query, string $type)
    {
        return $query->where('event_type', $type);
    }

    /**
     * Scope to filter by time range
     */
    public function scopeInTimeRange($query, $start, $end)
    {
        return $query->whereBetween('timestamp', [$start, $end]);
    }
}
