<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if user is authenticated
        if (!Auth::check()) {
            return redirect()->route('admin.login');
        }

        // For now, allow any authenticated user to access admin
        // In production, you should add is_admin field and check it here
        // $user = Auth::user();
        // if (!$user->is_admin) {
        //     return response()->view('errors.403', [], 403);
        // }

        return $next($request);
    }
}
