<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Subcategory;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    /**
     * Display a listing of categories.
     */
    public function index()
    {
        $categories = Category::with('subcategories')->get();

        return response()->json([
            'success' => true,
            'data' => $categories,
        ]);
    }

    /**
     * Display the specified category.
     */
    public function show($id)
    {
        $category = Category::with('subcategories')->findOrFail($id);

        return response()->json([
            'success' => true,
            'data' => $category,
        ]);
    }

    /**
     * Get subcategories for a specific category.
     */
    public function getSubcategories($id)
    {
        $category = Category::findOrFail($id);
        $subcategories = $category->subcategories;

        return response()->json([
            'success' => true,
            'data' => $subcategories,
        ]);
    }
}
