<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Page;
use Illuminate\Http\Request;

class PageController extends Controller
{
    /**
     * Get all active pages (for app menu/list)
     */
    public function index()
    {
        $pages = Page::active()->showInApp()->ordered()->get(['id', 'title', 'slug', 'order', 'meta']);
        
        return response()->json([
            'success' => true,
            'data' => $pages
        ]);
    }

    /**
     * Get single page content by slug
     */
    public function show($slug)
    {
        $page = Page::where('slug', $slug)->active()->first();

        if (!$page) {
            return response()->json([
                'success' => false,
                'message' => 'Page not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $page
        ]);
    }
}
