<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AdPackagePurchase;

class OrderController extends Controller
{
    /**
     * Get user's order history (Purchased Packages)
     */
    public function index(Request $request)
    {
        $orders = AdPackagePurchase::with(['package', 'pricingTier'])
            ->where('user_id', $request->user()->id)
            ->orderBy('created_at', 'desc')
            ->get();

        return response()->json([
            'success' => true,
            'data' => $orders
        ]);
    }
}
