<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Subcategory;
use Illuminate\Http\Request;

class SubcategoryController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'category_id' => 'required|exists:categories,id',
            'name' => 'required|string|max:255',
            'icon' => 'nullable|string',
            'description' => 'nullable|string',
            'status' => 'required|in:active,inactive',
            'order' => 'integer'
        ]);

        $subcategory = Subcategory::create([
            'category_id' => $request->category_id,
            'name' => $request->name,
            'slug' => str()->slug($request->name),
            'icon' => $request->icon ?? '📁',
            'description' => $request->description,
            'is_active' => $request->status === 'active',
            'sort_order' => $request->order,
        ]);

        return response()->json([
            'message' => 'Subcategory created successfully', 
            'subcategory' => $subcategory->loadCount('ads')
        ]);
    }

    public function update(Request $request, Subcategory $subcategory)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'required|in:active,inactive',
        ]);

        $subcategory->update([
            'name' => $request->name,
            'slug' => str()->slug($request->name),
            'icon' => $request->icon,
            'description' => $request->description,
            'is_active' => $request->status === 'active',
            'sort_order' => $request->order,
        ]);

        return response()->json(['message' => 'Subcategory updated successfully']);
    }

    public function destroy(Subcategory $subcategory)
    {
        $subcategory->delete();
        return response()->json(['message' => 'Subcategory deleted successfully']);
    }
}
