<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;

class SettingsController extends Controller
{
    public function update(Request $request)
    {
        $data = $request->except(['_token']);
        \Illuminate\Support\Facades\Log::info('Settings Update Request:', $data);
        
        // Checkboxes handling: if not present in request, it implies false (0)
        // We explicitly check for toggleable settings
        $checkboxes = [
            'enable_email_login', 
            'enable_google_login', 
            'allow_free_ad_posting',
            'email_verification_required',
            'phone_verification_required',
            'auto_approve_ads',
            // Guardian
            'guardian_enabled',
            'guardian_auto_ban',
            'guardian_chat_monitor'
        ];

        // Ensure advanced config default values if not present
        if (!$request->has('guardian_strict_threshold')) $data['guardian_strict_threshold'] = 80;
        if (!$request->has('guardian_balanced_threshold')) $data['guardian_balanced_threshold'] = 50;
        if (!$request->has('guardian_relaxed_threshold')) $data['guardian_relaxed_threshold'] = 20;

        foreach ($checkboxes as $checkbox) {
            if (!isset($data[$checkbox])) {
                $data[$checkbox] = '0';
            }
        }

        foreach ($data as $key => $value) {
            Setting::updateOrCreate(
                ['key' => $key],
                ['value' => $value]
            );
        }

        return redirect()->back()->with('success', 'Settings updated successfully');
    }
}
