<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PackagePricingController extends Controller
{
    /**
     * Store a newly created pricing tier in storage.
     */
    public function store(Request $request, $packageId)
    {
        $package = \App\Models\AdPackage::findOrFail($packageId);

        $validated = $request->validate([
            'validity_days' => 'required|integer|min:1',
            'base_price' => 'required|numeric|min:0',
            'discount_percentage' => 'nullable|integer|min:0|max:100',
            'ad_limit' => 'nullable|integer|min:1',
            'is_popular' => 'boolean',
        ]);

        $validated['is_popular'] = $request->has('is_popular');
        $validated['is_active'] = true;

        $package->pricingTiers()->create($validated);

        return redirect()->route('admin.packages.edit', $packageId)
            ->with('success', 'Pricing tier added successfully.');
    }

    /**
     * Remove the specified pricing tier from storage.
     */
    public function destroy($id)
    {
        $tier = \App\Models\PackagePricingTier::findOrFail($id);
        $packageId = $tier->package_id;
        $tier->delete();

        return redirect()->route('admin.packages.edit', $packageId)
            ->with('success', 'Pricing tier deleted successfully.');
    }
}
