<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\BannerPackage;
use Illuminate\Http\Request;

class BannerPackageController extends Controller
{
    public function index()
    {
        $packages = BannerPackage::orderBy('display_order')->get();
        return view('admin.banners.packages.index', compact('packages'));
    }

    public function create()
    {
        return view('admin.banners.packages.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'base_price_per_impression' => 'nullable|numeric|min:0',
            'base_price_per_click' => 'nullable|numeric|min:0',
            'max_impressions_included' => 'nullable|integer|min:0',
            'max_clicks_included' => 'nullable|integer|min:0',
            'features' => 'nullable|array',
            'discount_percentage' => 'nullable|numeric|min:0|max:100',
            'promotional_text' => 'nullable|string',
            'is_active' => 'boolean',
            'display_order' => 'nullable|integer',
        ]);

        BannerPackage::create($validated);

        return redirect()->route('admin.banner-packages.index')
            ->with('success', 'Package created successfully!');
    }

    public function edit(BannerPackage $bannerPackage)
    {
        return view('admin.banners.packages.edit', compact('bannerPackage'));
    }

    public function update(Request $request, BannerPackage $bannerPackage)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'base_price_per_impression' => 'nullable|numeric|min:0',
            'base_price_per_click' => 'nullable|numeric|min:0',
            'max_impressions_included' => 'nullable|integer|min:0',
            'max_clicks_included' => 'nullable|integer|min:0',
            'features' => 'nullable|array',
            'discount_percentage' => 'nullable|numeric|min:0|max:100',
            'promotional_text' => 'nullable|string',
            'is_active' => 'boolean',
            'display_order' => 'nullable|integer',
        ]);

        $bannerPackage->update($validated);

        return redirect()->route('admin.banner-packages.index')
            ->with('success', 'Package updated successfully!');
    }

    public function destroy(BannerPackage $bannerPackage)
    {
        $bannerPackage->delete();

        return redirect()->route('admin.banner-packages.index')
            ->with('success', 'Package deleted successfully!');
    }

    public function toggleStatus(BannerPackage $bannerPackage)
    {
        $bannerPackage->update(['is_active' => !$bannerPackage->is_active]);

        return redirect()->back()
            ->with('success', 'Package status updated!');
    }
}
