<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Ad;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AdDataController extends Controller
{
    /**
     * Get ads data for the frontend.
     */
    public function getAdsData(Request $request)
    {
        // For now, return sample data similar to what's in the frontend
        $ads = [
            [
                'id' => 1,
                'title' => 'iPhone 15 Pro Max',
                'category' => 'electronics',
                'price' => 1199.99,
                'currency' => 'USD',
                'status' => 'active',
                'isFeatured' => true,
                'sellerName' => 'Tech Store',
                'sellerEmail' => 'sales@techstore.com',
                'views' => 1234,
                'created' => '2024-01-15',
                'images' => ['https://images.unsplash.com/photo-1511707171634-5f897ff02aa9?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'San Francisco',
                    'state' => 'California',
                    'country' => 'USA'
                ]
            ],
            [
                'id' => 2,
                'title' => '2023 Tesla Model Y',
                'category' => 'vehicles',
                'price' => 52990.00,
                'currency' => 'USD',
                'status' => 'pending',
                'isFeatured' => false,
                'sellerName' => 'Auto Dealership',
                'sellerEmail' => 'sales@autodealer.com',
                'views' => 892,
                'created' => '2024-01-14',
                'images' => ['https://images.unsplash.com/photo-1580273916550-e323be2ae537?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Los Angeles',
                    'state' => 'California',
                    'country' => 'USA'
                ]
            ],
            [
                'id' => 3,
                'title' => 'Designer Watch Collection',
                'category' => 'fashion',
                'price' => 2999.50,
                'currency' => 'USD',
                'status' => 'sold',
                'isFeatured' => true,
                'sellerName' => 'Luxury Boutique',
                'sellerEmail' => 'info@luxuryboutique.com',
                'views' => 1567,
                'created' => '2024-01-13',
                'images' => ['https://images.unsplash.com/photo-1524805444758-089113d48a6d?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'New York',
                    'state' => 'New York',
                    'country' => 'USA'
                ]
            ],
            [
                'id' => 4,
                'title' => 'Modern Sofa Set',
                'category' => 'home-garden',
                'price' => 1299.00,
                'currency' => 'USD',
                'status' => 'active',
                'isFeatured' => false,
                'sellerName' => 'Home Decor',
                'sellerEmail' => 'sales@homedecor.com',
                'views' => 456,
                'created' => '2024-01-12',
                'images' => ['https://images.unsplash.com/photo-1519710164239-da123dc03ef4?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Chicago',
                    'state' => 'Illinois',
                    'country' => 'USA'
                ]
            ],
            [
                'id' => 5,
                'title' => '1 Bedroom Apartment',
                'category' => 'real-estate',
                'price' => 250000.00,
                'currency' => 'USD',
                'status' => 'active',
                'isFeatured' => true,
                'sellerName' => 'Real Estate Agent',
                'sellerEmail' => 'agent@realestate.com',
                'views' => 2156,
                'created' => '2024-01-11',
                'images' => ['https://images.unsplash.com/photo-1560448204-e02f11c3d0e2?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Miami',
                    'state' => 'Florida',
                    'country' => 'USA'
                ]
            ],
            [
                'id' => 6,
                'title' => 'Gaming Laptop RTX 4080',
                'category' => 'electronics',
                'price' => 2499.99,
                'currency' => 'USD',
                'status' => 'expired',
                'isFeatured' => false,
                'sellerName' => 'Gaming Store',
                'sellerEmail' => 'support@gamingstore.com',
                'views' => 891,
                'created' => '2024-01-10',
                'images' => ['https://images.unsplash.com/photo-1496181133206-80ce9b88a853?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Seattle',
                    'state' => 'Washington',
                    'country' => 'USA'
                ]
            ],
            [
                'id' => 7,
                'title' => 'Vintage Guitar',
                'category' => 'fashion',
                'price' => 899.00,
                'currency' => 'USD',
                'status' => 'active',
                'isFeatured' => false,
                'sellerName' => 'Music Shop',
                'sellerEmail' => 'info@musicshop.com',
                'views' => 342,
                'created' => '2024-01-09',
                'images' => ['https://images.unsplash.com/photo-1517457373958-b7bdd4587205?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Austin',
                    'state' => 'Texas',
                    'country' => 'USA'
                ]
            ],
            [
                'id' => 8,
                'title' => 'Family Car SUV',
                'category' => 'vehicles',
                'price' => 32000.00,
                'currency' => 'USD',
                'status' => 'pending',
                'isFeatured' => true,
                'sellerName' => 'Car Dealership',
                'sellerEmail' => 'sales@cardealer.com',
                'views' => 1123,
                'created' => '2024-01-08',
                'images' => ['https://images.unsplash.com/photo-1549317665-b5cda722d186?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Denver',
                    'state' => 'Colorado',
                    'country' => 'USA'
                ]
            ],
            [
                'id' => 9,
                'title' => 'Smart Home Security System',
                'category' => 'electronics',
                'price' => 499.99,
                'currency' => 'USD',
                'status' => 'active',
                'isFeatured' => false,
                'sellerName' => 'Tech Solutions',
                'sellerEmail' => 'support@techsolutions.com',
                'views' => 678,
                'created' => '2024-01-07',
                'images' => ['https://images.unsplash.com/photo-1581091012217-3c332b9b989c?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Boston',
                    'state' => 'Massachusetts',
                    'country' => 'USA'
                ]
            ],
            [
                'id' => 10,
                'title' => 'Office Desk Chair',
                'category' => 'home-garden',
                'price' => 299.50,
                'currency' => 'USD',
                'status' => 'active',
                'isFeatured' => false,
                'sellerName' => 'Office Supplies',
                'sellerEmail' => 'sales@officesupplies.com',
                'views' => 234,
                'created' => '2024-01-06',
                'images' => ['https://images.unsplash.com/photo-1519710164239-da123dc03ef4?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Philadelphia',
                    'state' => 'Pennsylvania',
                    'country' => 'USA'
                ]
            ],
            [
                'id' => 11,
                'title' => 'Designer Handbag',
                'category' => 'fashion',
                'price' => 1299.00,
                'currency' => 'EUR',
                'status' => 'active',
                'isFeatured' => true,
                'sellerName' => 'Boutique Paris',
                'sellerEmail' => 'contact@boutiqueparis.com',
                'views' => 567,
                'created' => '2024-01-05',
                'images' => ['https://images.unsplash.com/photo-1548126032-079a0fb0099d?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Paris',
                    'state' => 'Île-de-France',
                    'country' => 'France'
                ]
            ],
            [
                'id' => 12,
                'title' => 'Mountain Bike',
                'category' => 'vehicles',
                'price' => 899.99,
                'currency' => 'GBP',
                'status' => 'pending',
                'isFeatured' => false,
                'sellerName' => 'Cycle Shop',
                'sellerEmail' => 'info@cycleshop.co.uk',
                'views' => 432,
                'created' => '2024-01-04',
                'images' => ['https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'London',
                    'state' => 'England',
                    'country' => 'UK'
                ]
            ],
            [
                'id' => 13,
                'title' => 'Smartphone Samsung Galaxy',
                'category' => 'electronics',
                'price' => 899.00,
                'currency' => 'INR',
                'status' => 'active',
                'isFeatured' => false,
                'sellerName' => 'Tech India',
                'sellerEmail' => 'sales@techindia.com',
                'views' => 789,
                'created' => '2024-01-03',
                'images' => ['https://images.unsplash.com/photo-1511707171634-5f897ff02aa9?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Mumbai',
                    'state' => 'Maharashtra',
                    'country' => 'India'
                ]
            ],
            [
                'id' => 14,
                'title' => 'Designer Sunglasses',
                'category' => 'fashion',
                'price' => 299.00,
                'currency' => 'CAD',
                'status' => 'sold',
                'isFeatured' => true,
                'sellerName' => 'Style Canada',
                'sellerEmail' => 'hello@stylecanada.ca',
                'views' => 321,
                'created' => '2024-01-02',
                'images' => ['https://images.unsplash.com/photo-1528605248644-14dd04022da1?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Toronto',
                    'state' => 'Ontario',
                    'country' => 'Canada'
                ]
            ],
            [
                'id' => 15,
                'title' => 'Coffee Maker',
                'category' => 'home-garden',
                'price' => 199.99,
                'currency' => 'AUD',
                'status' => 'active',
                'isFeatured' => false,
                'sellerName' => 'Home Australia',
                'sellerEmail' => 'support@homeaustralia.com.au',
                'views' => 256,
                'created' => '2024-01-01',
                'images' => ['https://images.unsplash.com/photo-1595508184132-9d7e47be0deb?w=300&h=300&fit=crop'],
                'location' => [
                    'city' => 'Sydney',
                    'state' => 'New South Wales',
                    'country' => 'Australia'
                ]
            ]
        ];

        return response()->json([
            'ads' => $ads
        ]);
    }
}
