<?php

// Simple script to add admin user
require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\Hash;
use App\Models\User;

// Create admin user with specified credentials
try {
    $admin = User::create([
        'name' => 'Admin User',
        'email' => 'admin@donebro.in',
        'password' => Hash::make('123456'),
        'is_admin' => true,
        'is_verified' => true,
        'current_plan_id' => null,
    ]);
    
    echo "Admin user created successfully!\n";
    echo "Email: admin@donebro.in\n";
    echo "Password: 123456\n";
    echo "Admin ID: " . $admin->id . "\n";
} catch (Exception $e) {
    echo "Error creating admin user: " . $e->getMessage() . "\n";
}
