<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "Starting manual migration...\n";

try {
    if (!Schema::hasColumn('banner_packages', 'is_cpm_enabled')) {
        Schema::table('banner_packages', function (Blueprint $table) {
            $table->boolean('is_cpm_enabled')->default(true)->after('description');
            echo "Added is_cpm_enabled column.\n";
        });
    } else {
        echo "Column is_cpm_enabled already exists.\n";
    }

    if (!Schema::hasColumn('banner_packages', 'is_cpc_enabled')) {
        Schema::table('banner_packages', function (Blueprint $table) {
            $table->boolean('is_cpc_enabled')->default(false)->after('is_cpm_enabled');
            echo "Added is_cpc_enabled column.\n";
        });
    } else {
        echo "Column is_cpc_enabled already exists.\n";
    }
    
    echo "Migration completed successfully.\n";

} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
