# CLX Premium Classifieds Platform - Admin Setup Guide

## Simple Step-by-Step Instructions

### Problem
You're getting "The provided credentials do not match our records" when trying to login to the admin dashboard.

### Solution
The admin user needs to be created in the database. Here's how to fix it:

## Method 1: Easiest - Use the Setup Script (Recommended)

1. **Open Command Prompt or Terminal**
   - Press `Windows + R`, type `cmd`, and press Enter

2. **Navigate to the project folder**
   ```
   cd D:\DND\Apps\CLXpro\clx_backend
   ```

3. **Run the setup script**
   ```
   php setup_admin.php
   ```

4. **Wait for completion**
   - You should see messages like:
     - "Step 1: Running database migrations..."
     - "Step 2: Running database seeders..."
     - "Step 3: Verifying admin user..."
     - "✅ Admin user created successfully!"

5. **Access the admin dashboard**
   - Open your browser
   - Go to: http://127.0.0.1:8000/admin/login
   - Use:
     - **Email:** admin@donebro.in
     - **Password:** 123456

## Method 2: Manual Commands (If Method 1 doesn't work)

1. **Open Command Prompt or Terminal**
   - Press `Windows + R`, type `cmd`, and press Enter

2. **Navigate to the project folder**
   ```
   cd D:\DND\Apps\CLXpro\clx_backend
   ```

3. **Run these commands one by one:**
   ```
   php artisan migrate --force
   ```
   ```
   php artisan db:seed --class=AdminUserSeeder
   ```

4. **Access the admin dashboard**
   - Open your browser
   - Go to: http://127.0.0.1:8000/admin/login
   - Use:
     - **Email:** admin@donebro.in
     - **Password:** 123456

## Method 3: If You Get Errors

If you get any errors, it might be because:
- PHP is not installed
- Database connection is not configured
- Laravel dependencies are not installed

### Check if PHP is installed:
```
php --version
```
If you see a version number, PHP is installed. If you see an error, you need to install PHP.

### Check if Composer is installed:
```
composer --version
```
If you see a version number, Composer is installed.

### Install dependencies (if needed):
```
composer install
```

## What These Files Do

I've created these helper files for you:

1. **`setup_admin.php`** - One-click setup script (Method 1)
2. **`create_admin.sql`** - SQL script for manual database insertion
3. **`add_admin_user.php`** - Direct PHP script for user creation

## Troubleshooting

### If you get "php is not recognized":
- PHP is not installed or not in your PATH
- Download and install PHP from https://windows.php.net/
- Restart your command prompt

### If you get database connection errors:
- Check your `.env` file in the `clx_backend` folder
- Make sure database settings are correct:
  ```
  DB_CONNECTION=mysql
  DB_HOST=127.0.0.1
  DB_PORT=3306
  DB_DATABASE=your_database_name
  DB_USERNAME=your_username
  DB_PASSWORD=your_password
  ```

### If you need help:
- The setup script will show clear error messages
- Copy the error message and search online for solutions
- Or contact your developer/technical support

## Success!
Once the setup is complete, you should be able to:
- Access http://127.0.0.1:8000/admin/login
- Login with admin@donebro.in / 123456
- See the admin dashboard with all features

## Admin Dashboard Features
- User Management
- Ad Moderation
- Category Management
- Settings
- Analytics
- And much more!

---

**Note:** If you're still having trouble, please share what error messages you're seeing when you try to run the commands.
