# Persistent Admin Access Guide

## Overview

This guide explains how the CLXpro admin access system works and how to reset the database while preserving admin access.

## Admin Access Details

**Default Admin Credentials:**
- **Email:** `admin@donebro.in`
- **Password:** `123456`
- **Dashboard URL:** `/admin/login`

## How It Works

### 1. Persistent Admin User Seeder

The `AdminUserSeeder.php` uses `updateOrCreate()` instead of `create()` to ensure:
- The admin user is created if it doesn't exist
- The admin user is updated if it already exists (preserving access)
- Database resets won't remove admin access

### 2. Database Reset Process

When you reset the database, the admin user is automatically recreated with the same credentials.

## Resetting the Database

### Method 1: Using Laravel Artisan (Recommended)

```bash
cd clx_backend
php artisan migrate:fresh --seed
```

This command:
- Drops all tables
- Runs all migrations
- Seeds the database with fresh data
- Creates the admin user with persistent access

### Method 2: Using Custom Reset Script

```bash
cd clx_backend
php reset_database.php
```

This script provides additional verification and feedback.

### Method 3: Manual Seeder

If you only need to recreate the admin user:

```bash
cd clx_backend
php artisan db:seed --class=AdminUserSeeder
```

## Verification

After any database reset, verify admin access:

```bash
cd clx_backend
php check_admin.php
```

This script will confirm:
- Admin user exists
- Admin user has correct permissions
- Database reset was successful

## Admin User Properties

The admin user is configured with:
- `is_admin: true` - Grants admin privileges
- `is_verified: true` - Bypasses email verification
- `current_plan_id: null` - Admins don't need subscription plans
- `remember_token: null` - Clean session state

## Security Notes

- The admin password is stored as a hashed value (not plain text)
- Admin access is protected by Laravel's authentication system
- The admin user cannot be accidentally deleted during normal operations
- Use strong passwords in production environments

## Troubleshooting

### Admin User Not Found
If the admin user is missing after a reset:
1. Run the admin seeder manually: `php artisan db:seed --class=AdminUserSeeder`
2. Check the database connection
3. Verify the seeder file exists and is properly configured

### Database Connection Issues
Ensure:
- Database server is running
- `.env` file has correct database credentials
- Database exists and is accessible

### Migration Errors
If migrations fail:
1. Check database permissions
2. Verify database server version compatibility
3. Check for syntax errors in migration files

## Production Considerations

- Change the default admin password after initial setup
- Consider using environment variables for admin credentials
- Implement additional security measures (2FA, IP restrictions)
- Regularly audit admin account usage

## Files Modified

- `database/seeders/AdminUserSeeder.php` - Updated to use `updateOrCreate()`
- `reset_database.php` - Custom reset script with verification
- `check_admin.php` - Admin user verification script
- `PERSISTENT_ADMIN_ACCESS_GUIDE.md` - This documentation file

## Support

For issues related to admin access or database resets, refer to this guide or check the implementation files for additional details.
