# LARAGON SETUP GUIDE - Fix Admin Login Issue

## 🎯 Perfect! You have Laragon - This makes setup easy!

Since you have Laragon installed, you have everything you need: PHP, MySQL, and phpMyAdmin.

## Method 1: Using Laragon's Terminal (Easiest)

### Step 1: Open Laragon Terminal
1. Open Laragon
2. Click the **"Terminal"** button (bottom left)
3. This opens a command prompt with PHP and MySQL already configured

### Step 2: Navigate to project
```
cd D:\DND\Apps\CLXpro\clx_backend
```

### Step 3: Run the setup script
```
php setup_admin.php
```

**This should work perfectly with Laragon!**

## Method 2: If Method 1 fails - Use phpMyAdmin (Most Reliable)

### Step 1: Open phpMyAdmin
1. Open Laragon
2. Click **"MySQL"** → **"phpMyAdmin"**
3. This opens http://localhost/phpmyadmin in your browser

### Step 2: Create or select database
1. In phpMyAdmin, look at the left panel
2. If you see a database named `clx_premium` or similar, click it
3. If not, create one:
   - Click "New" in the left panel
   - Name: `clx_premium`
   - Click "Create"

### Step 3: Add admin user manually
1. Click the database name in the left panel
2. Click the **"SQL"** tab at the top
3. Copy and paste this SQL code:

```sql
INSERT INTO `users` (
    `name`, 
    `email`, 
    `password`, 
    `is_admin`, 
    `is_verified`, 
    `current_plan_id`, 
    `created_at`, 
    `updated_at`
) VALUES (
    'Admin User',
    'admin@donebro.in',
    '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi',
    1,
    1,
    NULL,
    NOW(),
    NOW()
) ON DUPLICATE KEY UPDATE 
    `name` = VALUES(`name`),
    `password` = VALUES(`password`),
    `is_admin` = VALUES(`is_admin`),
    `is_verified` = VALUES(`is_verified`),
    `updated_at` = NOW();
```

4. Click **"Go"** button

### Step 4: Check if tables exist
If you get an error about "Table 'users' doesn't exist":
1. You need to run migrations first
2. Go back to Laragon Terminal and run:
```
php artisan migrate --force
```

## Method 3: Check Database Configuration

### Step 1: Check your .env file
Open `clx_backend/.env` file and check these lines:
```
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=your_database_name_here
DB_USERNAME=root
DB_PASSWORD=
```

**For Laragon, it should be:**
```
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=clx_premium
DB_USERNAME=root
DB_PASSWORD=
```

**Note:** Laragon uses `root` as username and empty password by default.

### Step 2: Update .env file
1. Open `clx_backend/.env` in any text editor
2. Change `DB_DATABASE` to your actual database name
3. Make sure `DB_USERNAME=root` and `DB_PASSWORD=` (empty)

## Method 4: Complete Setup with Laragon

### Step 1: Start Laragon services
1. Open Laragon
2. Click **"Start All"** (if not already running)
3. Make sure Apache and MySQL are green

### Step 2: Open Laragon Terminal
1. Click the **"Terminal"** button
2. Navigate to project:
```
cd D:\DND\Apps\CLXpro\clx_backend
```

### Step 3: Run complete setup
```
composer install
php artisan migrate --force
php artisan db:seed --class=AdminUserSeeder
```

## 🎉 Success Check

After following any of these methods:

1. **Start your Laravel server:**
   ```
   php artisan serve
   ```

2. **Access admin dashboard:**
   - Open browser
   - Go to: http://127.0.0.1:8000/admin/login
   - Use:
     - **Email:** admin@donebro.in
     - **Password:** 123456

## 🆘 Troubleshooting for Laragon

### If you get "Database does not exist":
1. Create database in phpMyAdmin
2. Update `.env` file with correct database name
3. Run migrations: `php artisan migrate --force`

### If you get "Table 'users' doesn't exist":
1. Run migrations first: `php artisan migrate --force`
2. Then run seeder: `php artisan db:seed --class=AdminUserSeeder`

### If you get "Connection refused":
1. Make sure MySQL is running in Laragon (green light)
2. Check `.env` file has correct settings:
   ```
   DB_HOST=127.0.0.1
   DB_USERNAME=root
   DB_PASSWORD=
   ```

### If you get "php is not recognized":
- Use Laragon's Terminal instead of Windows Command Prompt
- Laragon Terminal has PHP configured automatically

## 🎯 Recommended Steps:

1. **Try Method 1 first** (Laragon Terminal with setup script)
2. **If that fails, try Method 2** (phpMyAdmin - most reliable)
3. **Check your .env file** if you get database errors

## 📋 What to Tell Me:

If you're still having trouble, please tell me:
1. What exact error message do you see?
2. Did you try the Laragon Terminal method?
3. Can you access http://localhost/phpmyadmin?
4. What happens when you run `php --version` in Laragon Terminal?

**Laragon makes this much easier - you should be able to get this working quickly!**
